/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.common.util.HardwareServerMessage;
import com.ibm.hsc.common.util.HardwareServerUtilities;
import com.ibm.hsc.vterm.VSerialSystemInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;

public class ActVSLIP {
    private static final int CONNECTION_UP = 0;
    private static final int CONNECTION_UP_REQUESTED = 1;
    private static final int CONNECTION_UP_BUT_INACTIVE = 34;
    private static final int CONNECTION_UP_LIST_REQUESTED = 35;
    private static final int CONNECTION_UP_BUT_HAS_DEFINED_IP = 36;
    private static final int CONNECTION_UP_CLEANUP_REQUESTED = 37;
    private static final int CONNECTION_UP_BUT_NEEDS_IP = 38;
    private static final int CONNECTION_UP_CONFIG_REQUESTED = 39;
    private static final int CONNECTION_DOWN = 128;
    private static final int CONNECTION_DOWN_GENESIS_STATE = 130;
    private static final int CONNECTION_DOWN_HARDWARE_SERVER_IS_GONE = 131;
    private static final int CONNECTION_DOWN_WAS_CLOSED = 132;
    private static final int CONNECTION_DOWN_PHYP_IS_NOT_RUNNING = 133;
    private static final int PHYP_VSLIP_DRC = 0x30000001;
    private static final int UNINITIALIZED_VPORT = -1;
    private static final int SPEED_AUTO = 0;
    private static final int DUPLEX_AUTO = 0;
    private static final int STATE_DOWN = 0;
    private static final int STATE_UP = 1;
    private static final int STATE_UNKNOWN = 255;
    private static final int LPAR_TARGET = 32769;
    private static final int LIST_IP_OPCODE = 3329;
    private static final int ADD_IP_OPCODE = 36098;
    private static final int REMOVE_IP_OPCODE = 36099;
    private static boolean debugFlag = false;
    private String m_hdwrSvrIpAddress = "localhost";
    private Socket m_hdwrSvrSocket;
    private InputStream m_socketInput;
    private DataOutputStream m_socketOutput;
    private static int m_hsCorrToken = 1;
    private ActVSLIPRecord[] m_vslipConnectionList;
    private byte[] m_subnetMask;
    private byte[] m_gateway;

    public static void main(String[] stringArray) {
        ActVSLIP actVSLIP = new ActVSLIP();
        actVSLIP.parseCommandLine(stringArray);
        actVSLIP.manageHardwareServerConnectionOuterLoop();
    }

    private void logTrace(String string) {
        if (debugFlag) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 1);
            System.err.println("TRC@" + dateFormat.format(new Date()) + ": " + string);
        }
    }

    private void logError(String string) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 1);
        System.err.println("ERR@" + dateFormat.format(new Date()) + ": " + string);
    }

    private void parseCommandLine(String[] stringArray) {
        int n;
        String string = "--hwsip=";
        this.logTrace("parsing command line. arg count = " + stringArray.length);
        if (stringArray.length == 0) {
            this.logError(" Usage: actvslip DecimalPartitionId*machinetype-machinemodel*machineSerialNumber");
        }
        Vector<ActVSLIPRecord> vector = new Vector<ActVSLIPRecord>();
        for (n = 0; n < stringArray.length; ++n) {
            String string2 = stringArray[n];
            int n2 = string2.indexOf(42);
            if (string2.startsWith(string)) {
                this.m_hdwrSvrIpAddress = string2.substring(string.length());
                this.logTrace("parsed hwsip= '" + this.m_hdwrSvrIpAddress + "'");
                continue;
            }
            if (string2.equalsIgnoreCase("--debug")) {
                debugFlag = true;
                this.logTrace("debug tracing enabled!");
                continue;
            }
            if (n2 > 0) {
                try {
                    String string3 = string2.substring(0, n2);
                    String string4 = string2.substring(n2 + 1);
                    int n3 = Integer.parseInt(string3);
                    ActVSLIPRecord actVSLIPRecord = new ActVSLIPRecord(string4, n3);
                    vector.add(actVSLIPRecord);
                    this.logTrace("parsed pid=" + n3 + " mtms='" + string4 + "'");
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    this.logError(string2 + " is not a valid parm of the form partitionid*type-model*serial");
                }
                catch (NumberFormatException numberFormatException) {
                    this.logError(string2 + " is not a valid parm of the form partitionid*type-model*serial");
                }
                continue;
            }
            this.logError(string2 + " is not a valid parm of the form partitionid*type-model*serial");
        }
        this.m_vslipConnectionList = new ActVSLIPRecord[vector.size()];
        for (n = 0; n < this.m_vslipConnectionList.length; ++n) {
            this.m_vslipConnectionList[n] = (ActVSLIPRecord)vector.get(n);
        }
    }

    private void connectToHardwareServer() throws IOException {
        this.m_hdwrSvrSocket = new Socket(this.m_hdwrSvrIpAddress, 8877);
        this.m_socketInput = this.m_hdwrSvrSocket.getInputStream();
        this.m_socketOutput = new DataOutputStream(this.m_hdwrSvrSocket.getOutputStream());
    }

    private void manageHardwareServerConnectionOuterLoop() {
        if (this.m_vslipConnectionList.length == 0) {
            this.logError("There are no VSLIP connections to manage.");
            return;
        }
        while (true) {
            try {
                this.connectToHardwareServer();
                this.logTrace("connected to hws @ " + this.m_hdwrSvrIpAddress);
                this.initializeGatewayAndSubnet();
                this.manageVSLIPConnectionsInnerLoop();
            }
            catch (IOException iOException) {
                this.logError("IOException when talking to hardware server @ '" + this.m_hdwrSvrIpAddress + "': " + iOException);
                iOException.printStackTrace();
            }
            catch (Throwable throwable) {
                this.logError("Unexpected exception when talking to hardware server: " + throwable);
                throwable.printStackTrace();
            }
            this.cleanupForHardwareServerDisconnect();
            try {
                Thread.sleep(15000L);
                continue;
            }
            catch (Throwable throwable) {
                this.logError("Unexpected exception while sleeping: " + throwable);
                continue;
            }
            break;
        }
    }

    private void initializeGatewayAndSubnet() throws IOException {
        byte[] byArray;
        this.logTrace("initializeGatewayAndSubnet");
        HardwareServerMessage hardwareServerMessage = new HardwareServerMessage(16, 50, 0, 0, null);
        this.logTrace("sending vslipqeuery: " + hardwareServerMessage);
        this.m_socketOutput.write(hardwareServerMessage.toBytes());
        HardwareServerMessage hardwareServerMessage2 = new HardwareServerMessage(this.m_socketInput);
        this.logTrace("vslipqeuery response: " + hardwareServerMessage2);
        if (hardwareServerMessage2.getMajorOpCode() != 16 || hardwareServerMessage2.getMinorOpCode() != 51) {
            System.err.println("This hardware server doesn't support the vslip query.");
            System.exit(1);
        }
        if ((byArray = hardwareServerMessage2.getPayload()).length >= 16) {
            this.m_gateway = new byte[4];
            this.m_gateway[0] = byArray[3];
            this.m_gateway[1] = byArray[2];
            this.m_gateway[2] = byArray[1];
            this.m_gateway[3] = byArray[0];
            this.m_subnetMask = new byte[4];
            this.m_subnetMask[0] = byArray[7];
            this.m_subnetMask[1] = byArray[6];
            this.m_subnetMask[2] = byArray[5];
            this.m_subnetMask[3] = byArray[4];
            String string = HardwareServerMessage.bytesToIPv4String(byArray, 0);
            String string2 = HardwareServerMessage.bytesToIPv4String(byArray, 4);
            this.logTrace("gateway ='" + string + "' subnet mask='" + string2 + "'");
        } else {
            System.err.println("Hardware server didn't return the full vslip query payload.");
            System.exit(1);
        }
    }

    private void manageVSLIPConnectionsInnerLoop() throws IOException {
        this.logTrace("manageVSLIPConnectionsInnerLoop");
        boolean bl = false;
        while (true) {
            if (!bl) {
                bl = this.updateVports();
            }
            boolean bl2 = true;
            for (int i = 0; i < this.m_vslipConnectionList.length; ++i) {
                if (this.m_vslipConnectionList[i].getConnectionState() == 0) continue;
                bl2 = false;
            }
            this.sendOpenVirtualSerialRequests();
            this.handlePHYPActivates();
            this.processResponseMesssages();
            try {
                if (bl2) {
                    Thread.sleep(10000L);
                    continue;
                }
                this.logTrace("connections are not all up");
                Thread.sleep(2000L);
                continue;
            }
            catch (Throwable throwable) {
                this.logError("Unexpected exception while sleeping: " + throwable);
                continue;
            }
            break;
        }
    }

    private boolean updateVports() throws IOException {
        this.logTrace("updateVports ->");
        boolean bl = true;
        for (int i = 0; i < this.m_vslipConnectionList.length; ++i) {
            if (this.m_vslipConnectionList[i].getCommandVport() != -1 && this.m_vslipConnectionList[i].getStreamVport() != -1) continue;
            bl = false;
            break;
        }
        if (bl) {
            return true;
        }
        HardwareServerUtilities hardwareServerUtilities = new HardwareServerUtilities(this.m_hdwrSvrIpAddress);
        VSerialSystemInfo[] vSerialSystemInfoArray = hardwareServerUtilities.listCECs();
        if (vSerialSystemInfoArray != null) {
            for (int i = 0; i < this.m_vslipConnectionList.length; ++i) {
                if (this.m_vslipConnectionList[i].getCommandVport() != -1 && this.m_vslipConnectionList[i].getStreamVport() != -1) continue;
                String string = this.m_vslipConnectionList[i].getMtms();
                for (int j = 0; j < vSerialSystemInfoArray.length; ++j) {
                    if (!string.equals(vSerialSystemInfoArray[j].m_type_model_serial) || !vSerialSystemInfoArray[j].isPrimaryFSP()) continue;
                    this.m_vslipConnectionList[i].setStreamVport(vSerialSystemInfoArray[j].m_hardware_server_vport_tty);
                    this.m_vslipConnectionList[i].setCommandVport(vSerialSystemInfoArray[j].m_hardware_server_vport);
                    this.logTrace("assigned vport " + this.m_vslipConnectionList[i].getCommandVport() + " to " + string);
                }
            }
        }
        return false;
    }

    private void sendOpenVirtualSerialRequests() throws IOException {
        this.logTrace("sendOpenVirtualSerialRequests ->");
        for (int i = 0; i < this.m_vslipConnectionList.length; ++i) {
            if (this.m_vslipConnectionList[i].getStreamVport() == -1 || this.m_vslipConnectionList[i].getConnectionState() < 128) continue;
            this.sendOpenVirtualSerialRequest(this.m_vslipConnectionList[i]);
            this.m_vslipConnectionList[i].setConnectionStateAndIPAddress(1, null);
        }
    }

    private void sendOpenVirtualSerialRequest(ActVSLIPRecord actVSLIPRecord) throws IOException {
        this.logTrace("sendOpenVirtualSerialRequest");
        HardwareServerMessage hardwareServerMessage = HardwareServerMessage.buildVserialOpenRequest(actVSLIPRecord.getStreamVport(), actVSLIPRecord.getPartitionId(), (short)actVSLIPRecord.getPartitionId(), (short)actVSLIPRecord.getSessionId(), (short)0, (short)3);
        this.logTrace("sending open virtual serial request: " + hardwareServerMessage);
        this.m_socketOutput.write(hardwareServerMessage.toBytes());
    }

    private void handlePHYPActivates() throws IOException {
        this.logTrace("handlePHYPActivates ->");
        block5: for (int i = 0; i < this.m_vslipConnectionList.length; ++i) {
            if (this.m_vslipConnectionList[i].getPartitionId() != 0) continue;
            switch (this.m_vslipConnectionList[i].getConnectionState()) {
                case 34: {
                    this.sendListIPConfigRequest(this.m_vslipConnectionList[i]);
                    this.m_vslipConnectionList[i].setConnectionState(35);
                    continue block5;
                }
                case 36: {
                    this.sendRemoveIPConfigRequest(this.m_vslipConnectionList[i]);
                    this.m_vslipConnectionList[i].setConnectionState(37);
                    continue block5;
                }
                case 38: {
                    this.sendAddIpConfigRequest(this.m_vslipConnectionList[i]);
                    this.m_vslipConnectionList[i].setConnectionState(39);
                }
            }
        }
    }

    private void sendListIPConfigRequest(ActVSLIPRecord actVSLIPRecord) throws IOException {
        this.logTrace("sendListIPConfigRequest");
        HardwareServerMessage hardwareServerMessage = HardwareServerUtilities.buildFspRequestMsg(actVSLIPRecord.getCommandVport(), 32769, 3329, 0xCACABA, null);
        this.logTrace("sending list ipconfig request: " + hardwareServerMessage);
        this.m_socketOutput.write(hardwareServerMessage.toBytes());
    }

    private void sendRemoveIPConfigRequest(ActVSLIPRecord actVSLIPRecord) throws IOException {
        this.logTrace("sendRemoveIPConfigRequest");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(0x30000001);
        HardwareServerMessage hardwareServerMessage = HardwareServerUtilities.buildFspRequestMsg(actVSLIPRecord.getCommandVport(), 32769, 36099, 0, byteArrayOutputStream.toByteArray());
        this.logTrace("sending remove ipconfig request: " + hardwareServerMessage);
        this.m_socketOutput.write(hardwareServerMessage.toBytes());
    }

    private static String IPAddrToString(int n) {
        return "" + (n >> 24 & 0xFF) + "." + (n >> 16 & 0xFF) + "." + (n >> 8 & 0xFF) + "." + (n & 0xFF);
    }

    private void sendAddIpConfigRequest(ActVSLIPRecord actVSLIPRecord) throws IOException {
        this.logTrace("sendAddIpConfigRequest");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(0x30000001);
        dataOutputStream.write(actVSLIPRecord.getIPAddressBinary(), 0, 4);
        dataOutputStream.write(this.m_subnetMask, 0, 4);
        dataOutputStream.write(this.m_gateway, 0, 4);
        dataOutputStream.write(this.m_gateway, 0, 4);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeByte(1);
        dataOutputStream.writeByte(0);
        HardwareServerMessage hardwareServerMessage = HardwareServerUtilities.buildFspRequestMsg(actVSLIPRecord.getCommandVport(), 32769, 36098, 0, byteArrayOutputStream.toByteArray());
        this.logTrace("sending add ipconfig request: " + hardwareServerMessage);
        this.m_socketOutput.write(hardwareServerMessage.toBytes());
    }

    private ActVSLIPRecord getActVSLIPRecordFromVportAndPartition(int n, int n2) {
        this.logTrace("getActVSLIPRecordFromVportAndPartition(" + n + ", " + n2);
        for (int i = 0; i < this.m_vslipConnectionList.length; ++i) {
            if (this.m_vslipConnectionList[i].getCommandVport() != n && this.m_vslipConnectionList[i].getStreamVport() != n || this.m_vslipConnectionList[i].getPartitionId() != n2) continue;
            return this.m_vslipConnectionList[i];
        }
        return null;
    }

    private void processResponseMesssages() throws IOException {
        this.logTrace("processResponseMesssages");
        block4: while (this.m_socketInput.available() > 0) {
            int n;
            Object object;
            HardwareServerMessage hardwareServerMessage = new HardwareServerMessage(this.m_socketInput);
            this.logTrace("incoming response message: " + hardwareServerMessage);
            byte[] byArray = hardwareServerMessage.getPayload();
            int n2 = hardwareServerMessage.getCorrelator();
            ActVSLIPRecord actVSLIPRecord = this.getActVSLIPRecordFromVportAndPartition(hardwareServerMessage.getVport(), n2);
            this.logTrace("Incoming msg correlator = 0x" + Long.toHexString(n2));
            if (hardwareServerMessage.getMajorOpCode() == 144) {
                switch (hardwareServerMessage.getMinorOpCode()) {
                    case 5: {
                        this.logTrace("Incoming open vserial response");
                        object = "";
                        if (byArray.length >= 4 && actVSLIPRecord != null) {
                            actVSLIPRecord.setConnectionStateAndIPAddress(actVSLIPRecord.m_partitionId == 0 ? 34 : 0, byArray);
                            continue block4;
                        }
                        this.logError("open vserial response invalid");
                        continue block4;
                    }
                    case 6: 
                    case 9: 
                    case 12: 
                    case 98: {
                        this.logTrace("Incoming failure response:");
                        continue block4;
                    }
                }
                this.logError("Unrecognized minor vserial incoming msg");
                continue;
            }
            if (hardwareServerMessage.getMajorOpCode() == 160) {
                if (hardwareServerMessage.getMinorOpCode() == 124) {
                    this.logTrace("Incoming vserial state async - it must be down...");
                    object = hardwareServerMessage.getPayload();
                    if (object == null || ((Object)object).length < 6) continue;
                    int n3 = HardwareServerMessage.bytesToUShort((byte[])object, 0);
                    int n4 = HardwareServerMessage.bytesToUShort((byte[])object, 2);
                    n = HardwareServerMessage.bytesToUShort((byte[])object, 4);
                    this.logTrace("Incoming pid=" + n3 + " sid=" + n4 + " newstate=" + n);
                    ActVSLIPRecord actVSLIPRecord2 = this.getActVSLIPRecordFromVportAndPartition(hardwareServerMessage.getVport(), n3);
                    actVSLIPRecord2.setConnectionStateAndIPAddress(132, null);
                    continue;
                }
                this.logError("Unrecognized minor async msg");
                continue;
            }
            if (hardwareServerMessage.getMajorOpCode() == 80) {
                object = HardwareServerUtilities.getFspPassthroughResponseErrorCode(hardwareServerMessage);
                if (((HardwareServerUtilities.FspMessageLight)object).parsingerror == 0L) {
                    if (((HardwareServerUtilities.FspMessageLight)object).target == 32769) {
                        actVSLIPRecord = this.getActVSLIPRecordFromVportAndPartition(hardwareServerMessage.getVport(), 0);
                        if (((HardwareServerUtilities.FspMessageLight)object).opcode == 36098) {
                            if (((HardwareServerUtilities.FspMessageLight)object).status == 0) {
                                actVSLIPRecord.setConnectionState(0);
                                continue;
                            }
                            this.logError("Add IP Command failed with status:" + Integer.toHexString(((HardwareServerUtilities.FspMessageLight)object).status));
                            continue;
                        }
                        if (((HardwareServerUtilities.FspMessageLight)object).opcode == 36099) {
                            if (((HardwareServerUtilities.FspMessageLight)object).status == 0) {
                                actVSLIPRecord.setConnectionState(34);
                                continue;
                            }
                            this.logError("Remove IP Command failed with status:" + Integer.toHexString(((HardwareServerUtilities.FspMessageLight)object).status));
                            continue;
                        }
                        if (((HardwareServerUtilities.FspMessageLight)object).opcode != 3329) continue;
                        if (((HardwareServerUtilities.FspMessageLight)object).status == 0) {
                            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((HardwareServerUtilities.FspMessageLight)object).payload);
                            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                            n = dataInputStream.readInt();
                            boolean bl = false;
                            for (int i = 0; i < n; ++i) {
                                int n5 = dataInputStream.readInt();
                                int n6 = dataInputStream.readInt();
                                int n7 = dataInputStream.readInt();
                                int n8 = dataInputStream.readInt();
                                int n9 = dataInputStream.readInt();
                                int n10 = dataInputStream.readByte() & 0xFF;
                                int n11 = dataInputStream.readByte() & 0xFF;
                                int n12 = dataInputStream.readByte() & 0xFF;
                                dataInputStream.readByte();
                                this.logTrace("Found IP[" + i + "] DRC=0x" + Integer.toHexString(n5) + " ip=" + ActVSLIP.IPAddrToString(n6) + " mask=" + ActVSLIP.IPAddrToString(n7) + " gw1=" + ActVSLIP.IPAddrToString(n8) + " gw2=" + ActVSLIP.IPAddrToString(n9));
                                if (n5 != 0x30000001) continue;
                                bl = true;
                            }
                            if (bl) {
                                actVSLIPRecord.setConnectionState(36);
                                continue;
                            }
                            actVSLIPRecord.setConnectionState(38);
                            continue;
                        }
                        this.logError("List IP Command failed with status:" + Integer.toHexString(((HardwareServerUtilities.FspMessageLight)object).status));
                        continue;
                    }
                    this.logError("unrecognized target " + Integer.toHexString(((HardwareServerUtilities.FspMessageLight)object).target));
                    continue;
                }
                this.logError("parsing error on message from FSP/PHYP.");
                continue;
            }
            this.logError("Unrecognized major opcode for incoming msg");
        }
    }

    private void cleanupForHardwareServerDisconnect() {
        this.logTrace("cleanupForHardwareServerDisconnect");
        for (int i = 0; i < this.m_vslipConnectionList.length; ++i) {
            if (this.m_vslipConnectionList[i].getConnectionState() != 0) continue;
            this.m_vslipConnectionList[i].setConnectionStateAndIPAddress(131, null);
            this.m_vslipConnectionList[i].setStreamVport(-1);
            this.m_vslipConnectionList[i].setCommandVport(-1);
        }
    }

    class ActVSLIPRecord {
        private String m_mtms;
        private int m_partitionId;
        private int m_sessionId;
        private int m_command_vport;
        private int m_stream_vport;
        private int m_connectionState;
        private byte[] m_ipaddressBinary;
        private String m_ipaddressStr;

        public ActVSLIPRecord(String string, int n) {
            this.m_mtms = string;
            this.m_partitionId = n;
            this.m_sessionId = 1;
            this.m_command_vport = -1;
            this.m_stream_vport = -1;
            this.m_connectionState = 128;
            this.m_ipaddressBinary = null;
        }

        public int getConnectionState() {
            return this.m_connectionState;
        }

        public String getMtms() {
            return this.m_mtms;
        }

        public int getPartitionId() {
            return this.m_partitionId;
        }

        public int getSessionId() {
            return this.m_sessionId;
        }

        public int getCommandVport() {
            return this.m_command_vport;
        }

        public int getStreamVport() {
            return this.m_stream_vport;
        }

        public String getIPAddressStr() {
            if (this.m_ipaddressBinary == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.m_ipaddressBinary[0] & 0xFF);
            stringBuffer.append(".");
            stringBuffer.append(this.m_ipaddressBinary[1] & 0xFF);
            stringBuffer.append(".");
            stringBuffer.append(this.m_ipaddressBinary[2] & 0xFF);
            stringBuffer.append(".");
            stringBuffer.append(this.m_ipaddressBinary[3] & 0xFF);
            return stringBuffer.toString();
        }

        public byte[] getIPAddressBinary() {
            return this.m_ipaddressBinary;
        }

        public void setConnectionStateAndIPAddress(int n, byte[] byArray) {
            this.m_connectionState = n;
            if (byArray == null) {
                this.m_ipaddressBinary = null;
            } else {
                this.m_ipaddressBinary = new byte[4];
                this.m_ipaddressBinary[0] = byArray[3];
                this.m_ipaddressBinary[1] = byArray[2];
                this.m_ipaddressBinary[2] = byArray[1];
                this.m_ipaddressBinary[3] = byArray[0];
            }
            this.printNewConnectionState();
        }

        public void setConnectionState(int n) {
            this.setConnectionStateAndIPAddress(n, this.m_ipaddressBinary);
        }

        public void setCommandVport(int n) {
            this.m_command_vport = n;
        }

        public void setStreamVport(int n) {
            this.m_stream_vport = n;
        }

        public void printNewConnectionState() {
            if (this.getConnectionState() == 0) {
                System.out.println(this.getPartitionId() + " " + this.getMtms() + " 0 " + this.getIPAddressStr());
            } else {
                System.out.print(this.getPartitionId() + " " + this.getMtms() + " " + Integer.toHexString(this.getConnectionState()) + " ");
                switch (this.getConnectionState()) {
                    case 128: {
                        System.out.println("Connection down");
                        break;
                    }
                    case 1: {
                        System.out.println("Connection up requested");
                        break;
                    }
                    case 34: {
                        System.out.println("Connection up but not yet activated.");
                        break;
                    }
                    case 35: {
                        System.out.println("Checking list of previous activations.");
                        break;
                    }
                    case 36: {
                        System.out.println("Connection has previous activations to cleanup.");
                        break;
                    }
                    case 37: {
                        System.out.println("Previous activation cleanup requested.");
                        break;
                    }
                    case 38: {
                        System.out.println("Previous activations are cleaned up. Activate next.");
                        break;
                    }
                    case 39: {
                        System.out.println("Activation of ip config requested.");
                        break;
                    }
                    case 130: {
                        System.out.println("Connection down genesis state");
                        break;
                    }
                    case 131: {
                        System.out.println("Connection down hardware server is gone");
                        break;
                    }
                    case 132: {
                        System.out.println("Connection down because it was closed");
                        break;
                    }
                    case 133: {
                        System.out.println("Connection down because phyp is not running");
                        break;
                    }
                    default: {
                        System.out.println("Unknown connection state");
                    }
                }
            }
        }
    }
}

